#!/bin/bash

test -f config.h && echo "==> skiping check" && exit 0


TEST_LIST="/bin /sbin /usr/bin /usr/sbin /usr/local/bin /usr/local/sbin"

echo -n "checking for mount.cifs... "


for i in $TEST_LIST 
do
	test -f "$i/mount.cifs" && MOUNT_CIFS=$i/mount.cifs\
								&& echo $i/mount.cifs\
								&& LINE1="#define MOUNT_CIFS \"$MOUNT_CIFS\""
done

[ "$MOUNT_CIFS" == "" ] && echo no && exit 1 

echo -n "checking for umount.cifs... "

for i in $TEST_LIST
do
	test -f "$i/umount.cifs" && UMOUNT_CIFS=$i/umount.cifs && UMOUNT_SET=1\
								&& echo $i/umount.cifs\
								&& LINE2="#define UMOUNT_CIFS \"$UMOUNT_CIFS\""
done

[ "$UMOUNT_CIFS" == "" ] && echo "no (using umount instead)"

[ "$LINE2" == "" ] && LINE2="#define UMOUNT_CIFS \"\""

echo "==> config.h created"

cat << EOF > config.h

#define REALLY_WORK

EOF


echo "$LINE1" >> config.h
echo "$LINE2" >> config.h
