#ifndef SCTJUDGE_JUDEGCORE_HEADER
#define SCTJUDGE_JUDEGCORE_HEADER

#include <unistd.h>
#include <pthread.h>
#include <semaphore.h>

extern pid_t pidchild;
extern pthread_mutex_t pidmutex, tkill_mx, tdisplay_mx, judge_tle_mx;
extern pthread_t tkill, tdisplay;
extern char tkill_yes, tdisplay_yes, judge_tle;
extern sem_t mcthr, addthr;

#define SCTMC_REDIR_STDERR 0x00000001
#define SCTMC_NOCOPY       0x00000002
#define SCTMC_SETUID       0x00000004
#define SCTMC_SETGID       0x00000008
#define SCTMC_VERBOSE      0x00000010
#define SCTMC_DRYRUN       0x00000020

struct makechildopt{
	char* executable;
	char* chrootdir;
	char* inputfile;
	char* outputfile;
	int exectime;
	int memlimit;
	int outlimit;
	int flags;
	uid_t uid;
	gid_t gid;
};

void* sctjudge_makechild(void*);
void* sctjudge_checktle(void*);
void* sctjudge_dispaytime(void*);

#endif
