#include "config.h"
#include "version.h"
#include "judge.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <pthread.h>
#include <pthread.h>
#include <semaphore.h>
#define SCTMAIN_ERRNOARG "%s: 選項「%s」之後需要一個參數"

int getargvint(int* ip, int argc, const char* prearg, const char* arg, 
		const char* argzero, const char* invalidmsg){
	int toreturn;
	(*ip)++;
	if((*ip) < argc){
		toreturn = atoi(arg);
		if(toreturn <= 0){
			fprintf(stderr, invalidmsg, argzero, arg);
			exit(1);
		}
	}else{
		fprintf(stderr, SCTMAIN_ERRNOARG, argzero, prearg);
		exit(1);
	}
	return toreturn;
}

char* getargvstr(int* ip, int argc, const char* prearg, const char* arg, 
		const char* argzero){
	char* toreturn;
	(*ip)++;
	if((*ip) < argc){
		toreturn = (char*)arg;
	}else{
		fprintf(stderr, SCTMAIN_ERRNOARG, argzero, prearg);
		exit(1);
	}
	return toreturn;
}

int main(int argc, char* argv[]){
	setlocale(LC_ALL, "");
	int i, j;
	char *tmpstr, *seppos;
	struct makechildopt mcopt; /* 送給 sctjudge_makechild 當參數用 */
	char verbose=0, dryrun=0;
	memset(&mcopt, 0 ,sizeof(mcopt));
	/* 據說有些 NULL 不是 0，所以還是設定一下比較保險 */
	mcopt.executable = NULL;
	mcopt.chrootdir = NULL;
	mcopt.inputfile = NULL;
	mcopt.outputfile = NULL;
	/* 解析命令列的時間到了 */
	for(i=1; i<argc; i++){
		if(argv[i][0] == '-'){
			if(!strcmp(&argv[i][1], "help") || !strcmp(&argv[i][1], "-help")){
				printf(SCTJUDGE_TITLEBAR"\n\n"
					"用法：%s [選項]\n"
					"選項：\n\n"
					"  -v/-verbose\n"
					"      顯示詳細執行過程\n\n"
					"  -version\n"
					"      顯示版本資訊\n\n"
					"  -n/-dryrun\n"
					"      只列出設定值而不要執行（包含 -v）\n\n"
					"  -t/-time <時間>\n"
					"      受測程式時間限制為<時間>毫秒\n\n"
					"  -m/-memory <大小>\n"
					"      受測程式記憶體限制<大小>MiB\n\n"
					"  -i/-input <檔案>\n"
					"      指定要導向至受測程式標準輸入的檔案，若未指定則為 "
					NULL_DEVICE"\n\n"
					"  -o/-output file=<檔案>[,stderr][,limit=<大小>]\n"
					"      設定受測程式輸出選項：\n\n"
					"      file=<檔案>\n"
					"          指定輸出檔案為<檔案>\n\n"
					"      stderr\n"
					"          將受測程式的標準錯誤也導向至輸出檔。若未指定，"
					"則只有標準輸\n"
					"          出會寫入輸出檔案，標準錯誤則被導向至 "
					NULL_DEVICE"\n\n"
					"      limit=<大小>\n"
					"          受測程式最多只能輸出<大小>MiB，若未指定則不限制"
					"\n"
					"          （無限制時請確定你有足夠的磁碟空間！\n\n"
					"  -e/-exec file=<檔案>[,nocopy]\n"
					"      設定受測程式可執行檔位置：\n\n"
					"      file=<檔案>\n"
					"          指定受測程式檔案名稱\n\n"
					"      nocopy\n"
					"          如果你啟用了 chroot 功能，預設情況下本程式會自"
					"動將檔案複製\n"
					"          到新的根目錄中，並在結束時自動刪除檔案。\n"
					"          使用此選項則取消自動複製的功能，但請注意：此時"
					" file 指定的\n"
					"          檔案名稱是相對於新的根目錄而不是現在的根目錄！"
					"\n\n"
					"  -chroot <目錄>\n"
					"          受測程式將以<目錄>為根目錄執行，若無此選項則關"
					"閉 chroot 功能\n\n"
					"  -u/-uid <UID>\n"
					"          受測程式將以 UID 為 <UID> 的使用者身份執行\n"
					"  -g/-gid <GID>\n"
					"          受測程式將以 GID 為 <GID> 的群組身份執行\n"
					"          此選項會同時設定 real/effective/supplementary "
					"GID(s)\n"
					"          原有的 supplementry GIDs 會被清空，只剩下這裡指"
					"定的數值\n\n"
					, argv[0]);
				return 0;
			}else if(!strcmp(&argv[i][1], "version") ||
					!strcmp(&argv[i][1], "-version")){
				puts(SCTJUDGE_TITLEBAR);
				exit(0);
			}else if(!strcmp(&argv[i][1], "v") || 
					!strcmp(&argv[i][1], "verbose")){
				verbose = 1;
				mcopt.flags |= SCTMC_VERBOSE;
			}else if(!strcmp(&argv[i][1], "n") || 
					!strcmp(&argv[i][1], "dryrun")){
				dryrun = 1, verbose = 1;
				mcopt.flags |= (SCTMC_DRYRUN | SCTMC_VERBOSE);
			}else if(!strcmp(&argv[i][1], "t") ||
					!strcmp(&argv[i][1], "time")){
				mcopt.exectime = getargvint(&i, argc, argv[i], argv[i+1], 
						argv[0], "%s: 「%s」不是正確的時間設定值\n");
			}else if(!strcmp(&argv[i][1], "m") ||
					!strcmp(&argv[i][1], "memory")){
				mcopt.memlimit = getargvint(&i, argc, argv[i], argv[i+1],
						argv[0], "%s: 「%s」不是正確的記憶體大小設定\n");
			}else if(!strcmp(&argv[i][1], "i") ||
					!strcmp(&argv[i][1], "input")){
				mcopt.inputfile = getargvstr(&i, argc, argv[i], argv[i+1],
					   	argv[0]);
			}else if(!strcmp(&argv[i][1], "o") ||
					!strcmp(&argv[i][1], "output")){
				getargvstr(&i, argc, argv[i], argv[i+1], argv[0]);
				/* XXX 寫得亂七八糟，哪天用函式包起來？ */
				for(tmpstr=strtok(argv[i], ","); tmpstr != NULL; 
						tmpstr=strtok(NULL, ",")){
					seppos = strchr(tmpstr, '=');
					if(seppos == NULL){
						if(!strcmp(tmpstr, "stderr")){
							mcopt.flags |= SCTMC_REDIR_STDERR;
						}else{
							fprintf(stderr, "%s: 在「%s」之後有個不存在或用法"
									"不正確的參數「%s」\n"
									, argv[0], argv[i-1], tmpstr);
							exit(1);
						}
					}else{
						j = seppos - tmpstr ;
						if(!strncmp(tmpstr, "limit", j)){
							mcopt.outlimit = atoi(tmpstr + j + 1);
							if(mcopt.outlimit <= 0){
								fprintf(stderr, "%s: 「%s」不是正確的輸出限制"
										"值\n", argv[0], tmpstr + j + 1);
								exit(1);
							}
						}else if(!strncmp(tmpstr, "file", j)){
							mcopt.outputfile = tmpstr + j + 1;
						}else{
							fprintf(stderr, "%s: 在「%s」之後有個不存在或用法"
									"不正確的參數「%s」\n"
									, argv[0], argv[i-1], tmpstr);
							exit(1);
						}
					}
				}
			}else if(!strcmp(&argv[i][1], "e") ||
					!strcmp(&argv[i][1], "exec")){
				/* XXX 同上！ */ 
				getargvstr(&i, argc, argv[i], argv[i+1], argv[0]);
				for(tmpstr=strtok(argv[i], ","); tmpstr != NULL; 
						tmpstr=strtok(NULL, ",")){
					seppos = strchr(tmpstr, '=');
					if(seppos == NULL){
						if(!strcmp(tmpstr, "nocopy")){
							mcopt.flags |= SCTMC_NOCOPY;
						}else{
							fprintf(stderr, "%s: 在「%s」之後有個不存在或用法"
									"不正確的參數「%s」\n", 
									argv[0], argv[i-1], tmpstr);
							exit(1);
						}
					}else{
						j = seppos - tmpstr ;
						if(!strncmp(tmpstr, "file", j)){
							mcopt.executable = tmpstr + j + 1;
						}else{
							fprintf(stderr, "%s: 在「%s」之後有個不存在或用法"
									"不正確的參數「%s」\n"
									, argv[0], argv[i-1], tmpstr);
							exit(1);
						}
					}
				}
			}else if(!strcmp(&argv[i][1], "chroot")){
				mcopt.chrootdir = getargvstr(&i, argc, argv[i], argv[i+1],
						argv[0]);
			}else if(!strcmp(&argv[i][1], "u") || !strcmp(&argv[i][1], "uid")){
				mcopt.flags |= SCTMC_SETUID;
				mcopt.uid = getargvint(&i, argc, argv[i], argv[i+1],
						argv[0], "%s: 指定 UID 為「%s」不安全或不合理\n");
			}else if(!strcmp(&argv[i][1], "g") || !strcmp(&argv[i][1], "gid")){
				mcopt.flags |= SCTMC_SETGID;
				mcopt.gid = getargvint(&i, argc, argv[i], argv[i+1],
						argv[0], "%s: 指定 GID 為「%s」不安全或不合理\n");
			}else{
				fprintf(stderr, "%s: 不明的選項「%s」\n", argv[0], argv[i]);
				return 1;
			}
		}else{
			fprintf(stderr, "%s: 參數 %d「%s」是多餘的\n"
				"請嘗試執行 %s -help 來取得說明\n"
				, argv[0], i, argv[i], argv[0]);
			return 1;
		}
	}
/* 至此可以進入主程式了 
 * XXX 一部分的判斷仍然放在其他 thread */
	if(verbose){
		puts(SCTJUDGE_TITLEBAR"\n");
	}
	pthread_t tmain; /* 其他 thread 的 ID 放在全域變數 */
	void* mtreturn; /* 接收 sctjudge_makechild 的回傳值 */
	int exectimelimit = mcopt.exectime, displayinterval = 256;
	pthread_attr_t detstate, joistate; 
	/* 除了主要的 sctjudge_makechild 以外，
	 * 我想其他的 thread 沒有 join 的必要 */
	pthread_attr_init(&detstate);
	pthread_attr_setdetachstate(&detstate, PTHREAD_CREATE_DETACHED);
	pthread_attr_init(&joistate);
	pthread_attr_setdetachstate(&joistate, PTHREAD_CREATE_JOINABLE);
	pthread_mutex_init(&pidmutex, NULL);
	pthread_mutex_init(&tkill_mx, NULL);
	pthread_mutex_init(&tdisplay_mx, NULL);
	pthread_mutex_init(&judge_tle_mx, NULL);
	sem_init(&mcthr, 0, 0);
	sem_init(&addthr, 0, 0);
	pthread_create(&tmain, &joistate, &sctjudge_makechild, (void*)&mcopt);
	if(!dryrun){
		pthread_create(&tkill, &detstate, &sctjudge_checktle, 
				(void*)&exectimelimit);
	}
	if(!dryrun && verbose){
		pthread_create(&tdisplay, &detstate, &sctjudge_dispaytime,
				(void*)&displayinterval);
	}
	pthread_attr_destroy(&detstate);
	pthread_attr_destroy(&joistate);
	sem_post(&mcthr); 
	/* 這個 semaphore 到這裡就沒用了， 
	 * sctjudge_makechild 一旦開始動就會把它 destroy 掉 */
	pthread_join(tmain, &mtreturn);
	/* XXX 底下這訊息很有可能讓使用者覺得很奇怪 */
	pthread_mutex_destroy(&pidmutex);
	pthread_mutex_destroy(&tkill_mx);
	pthread_mutex_destroy(&tdisplay_mx);
	if(*(int*)mtreturn != 0){
		fprintf(stderr, "%s: 因錯誤發生而結束程式\n", argv[0]);
		free(mtreturn);
		sem_destroy(&mcthr);
		exit(2);
	}else{
		free(mtreturn);
	}

	return 0;
}
