#include "judge.h"
#include "common.h"

#include <stdio.h>

#include <pthread.h>
#include <semaphore.h>

void* sctjudge_dispaytime(void* arg){
	pid_t pidcopy;
	unsigned disinterval = (*(int*)arg) * 1000 ;
	struct timespec timeinit, timecur, timepast;

	pthread_mutex_lock(&tdisplay_mx);
	tdisplay_yes = 1;
	pthread_mutex_unlock(&tdisplay_mx);

	pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

	sem_wait(&addthr);

	clock_gettime(CLOCK_REALTIME, &timeinit);

	pthread_mutex_lock(&pidmutex);
	pidcopy = pidchild;
	pthread_mutex_unlock(&pidmutex);

	putchar('\n');


	while(1){
		clock_gettime(CLOCK_REALTIME, &timecur);
		difftimespec(&timeinit, &timecur, &timepast);
		printf("\r%3ld.%03ld 秒", timepast.tv_sec,
				timepast.tv_nsec / 1000000);
		fflush(stdout);
		usleep(disinterval);
	}

	pthread_mutex_lock(&tdisplay_mx);
	tdisplay_yes = 0;
	pthread_mutex_unlock(&tdisplay_mx);

	return NULL;
}

