#include "common.h"

#include <time.h>
#include <unistd.h>
#include <sys/types.h>

#ifndef HAVE_LINUX_EXTENSIONS
static uid_t procrealuid = 0;
static uid_t proceffuid = 0;
#endif

void difftimespec(start, end, out)
	const struct timespec* start;
	const struct timespec* end;
	struct timespec* out;
{
	out->tv_sec = end->tv_sec - start->tv_sec;
	out->tv_nsec = end->tv_nsec - start->tv_nsec;
	if(out->tv_nsec < 0){
		out->tv_nsec += 1000000000;
		out->tv_sec--;
	}
}

#ifndef HAVE_LINUX_EXTENSIONS

void save_uids(void){	/* 這個一定要先執行，不然預設 uid 就是 0 */
	procrealuid = getuid();
	proceffuid = geteuid();
}

void disable_setuid(void){
#ifdef _POSIX_SAVED_IDS
	seteuid(procrealuid);
#else
	setreuid(proceffuid, procrealuid);
#endif
}

void enable_setuid(void){
#ifdef _POSIX_SAVED_IDS
	seteuid(proceffuid);
#else
	setreuid(procrealuid, proceffuid);
#endif
}

#endif
