#include "judge.h"
#include "common.h"

#include <stdio.h>
#include <string.h>

#include <pthread.h>
#include <semaphore.h>

void* sctjudge_dispaytime(void* arg){
	unsigned disinterval = (*(int*)arg) * 1000 ;
	struct timespec timeinit, timecur, timepast;

#ifdef HAVE_LINUX_EXTENSIONS
	int i;

	pid_t pidcopy;

	const char* sysstatfile = "/proc/stat";
	char statfile[25], statmfile[25], statusfile[25];
	FILE *statp, *statmp, *statusp, *sysstatp;

	int strlencount, pagesize, cpuinfostore;
	char firstrun = 1, hdrstore[10];

	unsigned long vmpagecount;
	unsigned long cpuuser, cpusystem, precpuuser, precpusystem;
	unsigned long syscpuall, presyscpuall, diffsyscpuall;

	unsigned short res_cpuuser, res_cpusystem;
	unsigned long vmsize;
#endif

	pthread_mutex_lock(&tdisplay_mx);
	tdisplay_yes = 1;
	pthread_mutex_unlock(&tdisplay_mx);

	pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

#ifndef HAVE_LINUX_EXTENSIONS
	enable_setuid();
#endif

	sem_wait(&addthr);

	clock_gettime(CLOCK_REALTIME, &timeinit);

#ifdef HAVE_LINUX_EXTENSIONS
	pthread_mutex_lock(&pidmutex);
	pidcopy = pidchild;
	pthread_mutex_unlock(&pidmutex);
#endif

	putchar('\n');

#ifdef HAVE_LINUX_EXTENSIONS
	sprintf(statfile, "/proc/%d/stat", pidcopy);
	sprintf(statmfile, "/proc/%d/statm", pidcopy);
	sprintf(statusfile, "/proc/%d/status", pidcopy);
	pagesize = getpagesize();
#endif

	while(1){
		clock_gettime(CLOCK_REALTIME, &timecur);
		difftimespec(&timeinit, &timecur, &timepast);
		printf("\r%4ld.%03ld 秒", timepast.tv_sec,
				timepast.tv_nsec / 1000000);
#ifdef HAVE_LINUX_EXTENSIONS
		statp = fopen(statfile, "r");
		statmp = fopen(statmfile, "r");
		statusp = fopen(statusfile, "r");
		sysstatp = fopen(sysstatfile, "r");
		if(statp != NULL && statmp != NULL && statusp != NULL &&
			   	sysstatp != NULL){
			strlencount = 0;
			while(getc(statusp) != '\n'){
				strlencount++;
			}
			strlencount -= 8; /* 把前面的「Name:   」這 8 個字去掉 */
			/* 接下來從 /proc/[PID]/stat 取得 CPU 時間 */
			fscanf(statp, "%*d"); /* 讀掉 PID */
			while(getc(statp) != '('); /* 讀掉 command name 的左括弧 */
			for(i=1; i<= strlencount; i++){ /* 讀掉整個 command name */
				getc(statp);
			}
			while(getc(statp) != ')'); /* 讀掉 command name 的右括弧 */
			fscanf(statp, "%*s %*d %*d %*d %*d %*d %*u %*u %*u %*u %*u"
					"%lu %lu", &cpuuser, &cpusystem);
			fscanf(statmp, "%lu", &vmpagecount);
			syscpuall = 0;
			while(!feof(sysstatp)){
				fscanf(sysstatp, "%9s", hdrstore);
				if(!strcmp(hdrstore, "cpu")){
					while(fscanf(sysstatp, "%d", &cpuinfostore) == 1){
						syscpuall += cpuinfostore;
					}
					break;
				}else{
					while(getchar() != '\n');
				}
			}
			if(!firstrun){
				diffsyscpuall = syscpuall - presyscpuall;
				res_cpuuser = 1000 * (cpuuser - precpuuser) / diffsyscpuall;
				res_cpusystem = 1000 * (cpusystem - precpusystem) / 
					diffsyscpuall;
				printf("  user%%: %2hd.%hd  sys%%: %2hd.%hd",
					res_cpuuser / 10, res_cpuuser % 10,
					res_cpusystem / 10, res_cpusystem % 10);
			}
			precpuuser = cpuuser;
			precpusystem = cpusystem;
			presyscpuall = syscpuall;
			vmsize = vmpagecount * pagesize / 1024;
			printf("  VM: %lu KiB", vmsize);
			fputs("                    ", stdout);
		}
		if(statp != NULL){
			fclose(statp);
		}
		if(statmp != NULL){
			fclose(statmp);
		}
		if(statusp != NULL){
			fclose(statusp);
		}
		if(sysstatp != NULL){
			fclose(sysstatp);
		}
		firstrun = 0;
#endif
		fflush(stdout);
		usleep(disinterval);
	}

	pthread_mutex_lock(&tdisplay_mx);
	tdisplay_yes = 0;
	pthread_mutex_unlock(&tdisplay_mx);

	return NULL;
}

