#include "judge.h"
#include "common.h"

#include <string.h>
#include <unistd.h>
#include <signal.h>

#include <pthread.h>
#include <semaphore.h>

volatile sig_atomic_t break_flag;

static void break_handler(int signo){
	break_flag = 1;
}

void* sctjudge_checktle(void* arg){
	pid_t pidcopy;
	unsigned sleeptime = *(int*)arg * 1000;
	struct sigaction break_catch;

	pthread_mutex_lock(&tkill_mx);
	tkill_yes = 1;
	pthread_mutex_unlock(&tkill_mx);

	pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

#ifndef HAVE_LINUX_EXTENSIONS
	enable_setuid();
#endif

	sem_wait(&addthr);

	break_flag = 0;
	memset(&break_catch, 0, sizeof(break_catch));
	break_catch.sa_handler = &break_handler;
	sigaction(SIGINT, &break_catch, NULL);
	sigaction(SIGTERM, &break_catch, NULL);

	pthread_mutex_lock(&pidmutex);
	pidcopy = pidchild;
	pthread_mutex_unlock(&pidmutex);


	/* 分成多個 sleep 會右誤差問題，之後應該要用 clock_gettime 修正 */
	while(sleeptime > 0 && !break_flag){
		if(sleeptime > 256000){
			sleeptime -= 256000;
			usleep(256000);
		}else{
			usleep(sleeptime);
			sleeptime = 0;
		}
	}

	if(!break_flag){
		pthread_mutex_lock(&judge_tle_mx);
		judge_tle = 1;
		pthread_mutex_unlock(&judge_tle_mx);
	}

	kill(pidcopy, SIGKILL);

	pthread_mutex_lock(&tkill_mx);
	tkill_yes = 0;
	pthread_mutex_unlock(&tkill_mx);
	return NULL;
}

